-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
dofile( "scripts/help_style.lua" );

kLineSpace3 = 75;
nameDialog = "help4";

HeaderTittle = "help_header_machine";

asset1 = "images/machines/stairmaster_1/normal";
asset2 = "images/machines/abroller_1/normal";
asset3 = "images/machines/elliptical_1/normal";
asset4 = "images/machines/stretching_mat/mat_3/normal";
asset5 = "images/ui/help/shower01";

Box1Tx = "help_machine_text_5_header";
Box2Tx = "help_machine_text_6_header";
Box3Tx = "help_machine_text_7_header";
Box4Tx = "help_machine_text_8_header";
Box5Tx = "help_machine_text_9_header";

definition1Tx = "help_machine_text_5";
definition2Tx = "help_machine_text_6";
definition3Tx = "help_machine_text_7";
definition4Tx = "help_machine_text_8";
definition5Tx = "help_machine_text_9";

paginateLabel = "help_paginate_4";

function BackCommand() 
	SwapToModal("scripts/help3.lua");
end

function NextCommand() 
	SwapToModal("scripts/help5.lua");
end

MakeDialog
{
	-- Name the modal dialog
	name = nameDialog,
	Bitmap
	{
		image="images/backgrounds/bgpopup01",
		x=kCenter,
		y=kCenter,
		
		Bitmap
		{
			image="images/ui/common/popup05",
			x=0,
			y=0,
		};
--Tittle
		Text
		{
			font = BigPopupFont,
			x=kCenter,
			y=kTitleY,
			w=kMax,h=45,
			flags = kHAlignCenter + kVAlignCenter,
			label = "help",
		};
--Header
		Text
		{
			font = PopupFont,
			x=kTextHeaderX,
			y=kTextHeaderY,
			w=kMax,h=45,
			flags = kHAlignLeft + kVAlignCenter,
			label = HeaderTittle,
		};
--Line 1
		Bitmap
		{
			image="images/ui/buttons/box06",
			x=kFirstRow,
			y=kFirstLine,
			Bitmap
			{
				image=asset1,
				x=25,
				y=5,
				scale = 0.7,
			};
		};
		
--Machine1 Name
		Bitmap
		{
			image="images/ui/buttons/box02",
			x=kFirstRow+kRowSpace,
			y=kFirstLine,
	
			Text
			{
				font = MachineFont,
				x=5,
				y=3,
				w=kMax,h=20,
				flags = kHAlignLeft + kVAlignCenter,
				label = Box1Tx,
			};
		};
		SetStyle(HelpTxDefStyle),
		Text
		{
			x=kFirstRow+kRowSpace,
			y=kFirstLine+kTextSpaceUnderBox,
			label = definition1Tx,
		};
--Line 2
		Bitmap
		{
			image="images/ui/buttons/box06",
			x=kFirstRow,
			y=kFirstLine+kLineSpace3,
			Bitmap
			{
				image=asset2,
				x=20,
				y=10,
				scale = 0.8,
			};
		};
--Machine2 Name
		Bitmap
		{
			image="images/ui/buttons/box02",
			x=kFirstRow+kRowSpace,
			y=kFirstLine+kLineSpace3,
	
			Text
			{
				font = MachineFont,
				x=5,
				y=3,
				w=kMax,h=20,
				flags = kHAlignLeft + kVAlignCenter,
				label = Box2Tx,
			};
		};
		Text
		{
			x=kFirstRow+kRowSpace,
			y=kFirstLine+kTextSpaceUnderBox+kLineSpace3,
			label = definition2Tx,
		};
--Line 3
		Bitmap
		{
			image="images/ui/buttons/box06",
			x=kFirstRow,
			y=kFirstLine+2*kLineSpace3,
			Bitmap
			{
				image=asset3,
				x=20,
				y=10,
				scale = 0.8,
			};
		};
--Machine3 Name
		Bitmap
		{
			image="images/ui/buttons/box02",
			x=kFirstRow+kRowSpace,
			y=kFirstLine+2*kLineSpace3,
	
			Text
			{
				font = MachineFont,
				x=5,
				y=3,
				w=kMax,h=20,
				flags = kHAlignLeft + kVAlignCenter,
				label = Box3Tx,
			};
		};
		Text
		{
			x=kFirstRow+kRowSpace,
			y=kFirstLine+kTextSpaceUnderBox+2*kLineSpace3,
			label = definition3Tx,
		};
--Line 4
		Bitmap
		{
			image="images/ui/buttons/box06",
			x=kFirstRow,
			y=kFirstLine+3*kLineSpace3,
			Bitmap
			{
				image=asset4,
				x=25,
				y=20,
				scale = 0.8,
			};
		};
--Machine4 Name
		Bitmap
		{
			image="images/ui/buttons/box02",
			x=kFirstRow+kRowSpace,
			y=kFirstLine+3*kLineSpace3,
	
			Text
			{
				font = MachineFont,
				x=5,
				y=3,
				w=kMax,h=20,
				flags = kHAlignLeft + kVAlignCenter,
				label = Box4Tx,
			};
		};
		Text
		{
			x=kFirstRow+kRowSpace,
			y=kFirstLine+kTextSpaceUnderBox+3*kLineSpace3,
			label = definition4Tx,
		};
--Line 5
		Bitmap
		{
			image="images/ui/buttons/box06",
			x=kFirstRow,
			y=kFirstLine+4*kLineSpace3,
			Bitmap
			{
				image=asset5,
				x=35,
				y=2,
				scale = 0.47,
			};
		};
--Machine5 Name
		Bitmap
		{
			image="images/ui/buttons/box02",
			x=kFirstRow+kRowSpace,
			y=kFirstLine+4*kLineSpace3,
	
			Text
			{
				font = MachineFont,
				x=5,
				y=3,
				w=kMax,h=20,
				flags = kHAlignLeft + kVAlignCenter,
				label = Box5Tx,
			};
		};
		Text
		{
			x=kFirstRow+kRowSpace,
			y=kFirstLine+kTextSpaceUnderBox+4*kLineSpace3,
			label = definition5Tx,
		};
		SetStyle(FitnessButtonStyleTittleSmallBlue),
--//Back
		SBButton
		{
			x=kButtonX,
			y=kButtonY,
			
			icon="assets/images/ui/buttons/icon/iconback",
			command=
				function()
					-- Our game provides this call--it's not a Playground
					-- call.
                    BackCommand();
				end
		},
		Text
		{
			font = SmallFont,
			x=kButtonX,
			y=kButtonY+kTextY,
			flags = kHAlignCenter + kVAlignCenter,
			label = "common.back.label",
		};
--Next
		SBButton
		{
			x=kButtonX+kButtonSpaceX,
			y=kButtonY,
			
			icon="assets/images/ui/buttons/icon/iconplay",
			command=
				function()
					-- Our game provides this call--it's not a Playground
					-- call.
                    NextCommand();
				end
		},
		Text
		{
			font = SmallFont,
			x=kButtonX+kButtonSpaceX,
			y=kButtonY+kTextY,
			flags = kHAlignCenter + kVAlignCenter,
			label = "next",
		};
--Paginate
		Text
		{
			font = SmallFontBlack,
			flags = kHAlignCenter + kVAlignCenter,
			x=kPaginateX,
			y=kPaginateY,
			w=kMax,h=30,
			
			label = paginateLabel,
		};
	}
}

